#==============================================================================
#  Markup_Font_Size
#------------------------------------------------------------------------------
# }[NAbvtHgTCY
# Copyright (C) 2005 fukuyama
#==============================================================================
#
# \FS[l]  tHgTCYύX
#
#==============================================================================

module Markup_Font_Size
  module_function
  def query
    return /^\\FS\[([-+]?)([0-9]+)\]/
  end
  def transfer(bmp, x, y, text, match)
    if match[1].empty?
      font_size = match[2].to_i
    else
      font_size = bmp.font.size + (match[1]+match[2]).to_i
    end
    if font_size == 0
      bmp.font.size = Font.default_size
    elsif font_size < 6
      bmp.font.size = 6
    else
      bmp.font.size = font_size
    end
    text[query] = ''
    return x,y,text
  end
end

String_Operation_Module.add_markup(Markup_Font_Size)
